'-------------------------------------------------------------------------
'This is used when, for example, you have a path in the registry without the backslash at the end
'For example you have a registry that points to C:\Windows\Temp
'See how you don't have the last backslash (in the form of C:\Windows\Temp\)
'In this example we take the INSTALLDIR from the MSI as a session.property, but you can change with any other directory property you like
'At the end we return the value C:\Windows\Temp back to the MSI property called NOS_INSTALLDIR
'Make sure NOS_INSTALLDIR is created and set with 0 in your MSI
'--------------------------------------------------------------------------
Set objFSO = CreateObject("Scripting.FileSystemObject")

Dim s
s = Session.Property("INSTALLDIR")
If (Len(s) > 0) Then 
		If (Right(s, 1) = "\") Then
			s = Left(s, (Len(s) - 1))
		End If
End If
Session.Property("NOS_INSTALLDIR") = s
